 /*******************************************************************
 *
 *  DESCRIPTION: Atomic Model Queue
 *
 *  AUTHOR: Misagh Tavanpour
 *
 *  DATE: 22/10/2012
 *
 *******************************************************************/

 #ifndef __QUEUE1_H
 #define __QUEUE1_H

 #include "atomic.h"     // class Atomic
 #include "string.h"	 // class String
 #include "list.h"

 class Queue1 : public Atomic
 {
   public:
	       Queue1( const std::string &name = "Queue1" );	//Default constructor
	       virtual std::string className() const { return "Queue1"; }
	       ~Queue1();

   protected:
	          Model &initFunction();
	          Model &externalFunction( const ExternalMessage & );
	          Model &internalFunction( const InternalMessage & );
	          Model &outputFunction( const InternalMessage & );

   private:
	        const Port &In,&Req;
	        Port &Out;
	        Time ProcessTime;
	        typedef list<Value> ElementList ;
	        ElementList elements;
	        int Request;
	        int Qlen;
         	enum State{
			            Idle,       //initial state
			            Push,
			            Pop,
		              };
		    State state;
 };	// class Queue1

 #endif   //__QUEUE1_H
